using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;

namespace nsAlienMobileSDK
{
    public partial class FormConnectToHost : Form
    {
        internal IPAddress HostIPAddress = null;
        internal int Port = 0;

        public FormConnectToHost()
        {
            InitializeComponent();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            HostIPAddress = IPAddress.Parse(txtAddress.Text.Trim());  // to validate it
            Port = int.Parse(txtPort.Text.Trim());

            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void frmConnectToHost_Load(object sender, EventArgs e)
        {
            if (HostIPAddress == null)
            {
                txtAddress.Select(0, txtAddress.Text.Length);
                txtAddress.Focus();
            }
            else if (Port == 0)
            {
                txtPort.Select(0, txtPort.Text.Length);
                txtPort.Focus();
            }
            else
                btnOK.Focus();

            this.DialogResult = DialogResult.None;
        }
    }
}